/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.affix;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.champions.api.AffixCategory;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.affix.core.BasicAffix;
import top.theillusivec4.champions.common.config.ChampionsConfig;

public class ReflectiveAffix
extends BasicAffix {
    private static final String REFLECTION_DAMAGE = "reflection";

    public ReflectiveAffix() {
        super("reflective", AffixCategory.OFFENSE, true);
    }

    @SubscribeEvent
    public void onDamageEvent(LivingDamageEvent evt) {
        if (!ChampionsConfig.reflectiveLethal && evt.getSource().m_19385_().equals(REFLECTION_DAMAGE)) {
            LivingEntity living = evt.getEntityLiving();
            float currentDamage = evt.getAmount();
            if (currentDamage >= living.m_21223_()) {
                evt.setAmount(living.m_21223_() - 1.0f);
            }
        }
    }

    @Override
    public float onDamage(IChampion champion, DamageSource source, float amount, float newAmount) {
        Entity entity = source.m_7640_();
        if (entity instanceof LivingEntity) {
            LivingEntity sourceEntity = (LivingEntity)entity;
            if (source.m_19385_().equals(REFLECTION_DAMAGE) || source instanceof EntityDamageSource && ((EntityDamageSource)source).m_19403_()) {
                return newAmount;
            }
            DamageSource newSource = new DamageSource(REFLECTION_DAMAGE);
            if (source instanceof IndirectEntityDamageSource && source.m_7640_() != null) {
                newSource = new IndirectEntityDamageSource(REFLECTION_DAMAGE, source.m_7640_(), source.m_7640_());
                ((IndirectEntityDamageSource)newSource).m_19402_();
            } else if (source instanceof EntityDamageSource) {
                newSource = new EntityDamageSource(REFLECTION_DAMAGE, source.m_7640_());
                ((EntityDamageSource)newSource).m_19402_();
            }
            float min = (float)ChampionsConfig.reflectiveMinPercent;
            if (source.m_19384_()) {
                newSource.m_19383_();
            }
            if (source.m_19360_()) {
                newSource.m_19366_();
            }
            if (source.m_19372_()) {
                newSource.m_19375_();
            }
            if (source.m_19387_()) {
                newSource.m_19389_();
            }
            if (source.m_146705_()) {
                newSource.m_146706_();
            }
            if (source.m_19376_()) {
                newSource.m_19380_();
            }
            if (source.m_7986_()) {
                newSource.m_19386_();
            }
            if (source.m_19378_()) {
                newSource.m_19381_();
            }
            float damage = (float)Math.min((double)amount * ((double)sourceEntity.m_21187_().nextFloat() * (ChampionsConfig.reflectiveMaxPercent - (double)min) + (double)min), (double)ChampionsConfig.reflectiveMax);
            sourceEntity.m_6469_(newSource, damage);
        }
        return newAmount;
    }
}

